using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using Common = gov.va.med.vbecs.Common;
using gov.va.med.vbecs;
using gov.va.med.vbecs.BOL;
using System.Text;
using gov.va.med.vbecs.GUI;
using System.Threading;
using REAGENTTYPEPARAMETER = gov.va.med.vbecs.Common.VbecsTables.ReagentTypeParameter;
using RACK = gov.va.med.vbecs.Common.VbecsTables.Rack;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmConfigureReagent
	/// </summary>
	public class FrmConfigureReagent : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Form Controls
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpActivate;
		private System.Windows.Forms.DateTimePicker dtpAlertTime;
		private System.Windows.Forms.Label lblAlertTime;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updNumberOfRacks;
		private System.Windows.Forms.Label lblNumberOfRacks;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.GroupBox groupBox1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrimaryEnhancement;
		private System.Windows.Forms.Label lblSecondaryEnhancement;
		private System.Windows.Forms.Label lblPrimaryEnhancement;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbSecondaryEnhancement;
		private System.Windows.Forms.Label lblInfo;
		private System.Windows.Forms.ListView lvCommercial;
		private System.Windows.Forms.ColumnHeader colUsed;
		private System.Windows.Forms.ColumnHeader colReagentType;
		private System.Windows.Forms.ColumnHeader colTestWith;
		private System.Windows.Forms.ListView lvNonCommercial;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader colMinReactions;
		private System.Windows.Forms.RadioButton rdo1To25;
		private System.Windows.Forms.RadioButton rdoAtoZ;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem mnuEditReactionLevel;
		private System.Windows.Forms.ColumnHeader colMinReaction;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Panel pnlTemplateType;
		private System.Windows.Forms.RadioButton rdoNonCommercial;
		private System.Windows.Forms.RadioButton rdoCommerical;
		private System.Windows.Forms.Label label3; 

		#endregion

		#region Variables
		private BOL.DailyControl _dailyControl;
		private BOL.DailyControl _existingDailyControl;
		private System.Collections.ArrayList _alReagentQCNonCommercialData;
		private System.Collections.ArrayList _alReagentQCCommercialData;
		private System.Collections.ArrayList _alEnhancementMedia;
		

		BOL.ReagentType _reagentComType;
        BOL.ReagentType _reagentNonComType;
		BOL.ReagentType _selectedReagentTypeNonCom;
        BOL.ReagentType _selectedReagentTypeCom;
		private bool _isLoading;
		private bool _ignoreCheckChanged = false;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnEditMinReaction;
		/// <summary>
		/// _bFirstTimeConfiguation lets you know if you need to inactivate prior daily control entries
		/// we are always inserting new entries but if no prior entires exist then no inactivation
		/// needs to take place
		/// </summary>
		private bool _bFirstTimeConfiguration;
		
		#endregion

		#region Constructors/Dispspose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmConfigureReagent()
		{	
			this.LockController.LockFunction = Common.LockFunctions.UC051ConfigureDailyReagentQC;

			// This call is required by the Windows Form Designer.
			this._isLoading = true;
			InitializeComponent();
			SetComponentProperties();
			
			_dailyControl = new BOL.DailyControl();
			_dailyControl.RecordStatusCode = Common.RecordStatusCode.Active;
			ReattachEvents();
			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Events /Event Handlers
		private void ReattachEvents()
		{
			this._dailyControl.Invalid += new System.EventHandler(OnInvalid);
			this._dailyControl.Valid += new System.EventHandler(OnValid);
			
			//setting the event to fire the setdirtyflag function
			this._dailyControl.Invalid += new System.EventHandler(this.SetDirtyFlag);

			this._dailyControl.PrimaryEnhancementMedia.Invalid += new System.EventHandler(OnInvalid);
			this._dailyControl.PrimaryEnhancementMedia.Valid += new System.EventHandler(OnValid);
			
			//setting the event to fire the setdirtyflag function
			this._dailyControl.PrimaryEnhancementMedia.Invalid += new System.EventHandler(this.SetDirtyFlag);
			
			this._dailyControl.SecondaryEnhancementMedia.Invalid += new System.EventHandler(OnInvalid);
			this._dailyControl.SecondaryEnhancementMedia.Valid += new System.EventHandler(OnValid);

			//setting the event to fire the setdirtyflag function
			this._dailyControl.SecondaryEnhancementMedia.Invalid += new System.EventHandler(this.SetDirtyFlag);
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmConfigureReagent));
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.dtpAlertTime = new System.Windows.Forms.DateTimePicker();
            this.updNumberOfRacks = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
            this.cmbPrimaryEnhancement = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.cmbSecondaryEnhancement = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lvCommercial = new System.Windows.Forms.ListView();
            this.colUsed = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colReagentType = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colTestWith = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colMinReaction = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.contextMenu1 = new System.Windows.Forms.ContextMenu();
            this.mnuEditReactionLevel = new System.Windows.Forms.MenuItem();
            this.lvNonCommercial = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colMinReactions = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.btnCancel = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpActivate = new System.Windows.Forms.GroupBox();
            this.pnlTemplateType = new System.Windows.Forms.Panel();
            this.rdoNonCommercial = new System.Windows.Forms.RadioButton();
            this.rdoCommerical = new System.Windows.Forms.RadioButton();
            this.label3 = new System.Windows.Forms.Label();
            this.rdo1To25 = new System.Windows.Forms.RadioButton();
            this.rdoAtoZ = new System.Windows.Forms.RadioButton();
            this.lblAlertTime = new System.Windows.Forms.Label();
            this.lblNumberOfRacks = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.btnEditMinReaction = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.lblInfo = new System.Windows.Forms.Label();
            this.lblSecondaryEnhancement = new System.Windows.Forms.Label();
            this.lblPrimaryEnhancement = new System.Windows.Forms.Label();
            this.errorProvider1 = new System.Windows.Forms.ErrorProvider(this.components);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.updNumberOfRacks)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpActivate.SuspendLayout();
            this.pnlTemplateType.SuspendLayout();
            this.groupBox1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.errorProvider1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(632, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Configure Daily Reagent QC";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 461);
            this.lblRequiredField.TabIndex = 6;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(472, 450);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 12;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // dtpAlertTime
            // 
            this.dtpAlertTime.AccessibleDescription = "Daily Alert Time";
            this.dtpAlertTime.AccessibleName = "Daily Alert Time";
            this.dtpAlertTime.CustomFormat = "";
            this.dtpAlertTime.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpAlertTime.Location = new System.Drawing.Point(384, 32);
            this.dtpAlertTime.Name = "dtpAlertTime";
            this.dtpAlertTime.ShowUpDown = true;
            this.dtpAlertTime.Size = new System.Drawing.Size(80, 20);
            this.dtpAlertTime.TabIndex = 4;
            this.toolTip1.SetToolTip(this.dtpAlertTime, "Select the time of day that the daily alert to all VBECS users should begin.");
            this.dtpAlertTime.ValueChanged += new System.EventHandler(this.dtpAlertTime_ValueChanged);
            this.dtpAlertTime.Leave += new System.EventHandler(this.dtpAlertTime_Leave);
            // 
            // updNumberOfRacks
            // 
            this.updNumberOfRacks.AccessibleDescription = "Number of racks to be Q C\'d daily";
            this.updNumberOfRacks.AccessibleName = "Number of racks to be Q C\'d daily";
            this.updNumberOfRacks.Location = new System.Drawing.Point(180, 32);
            this.updNumberOfRacks.Maximum = new decimal(new int[] {
            26,
            0,
            0,
            0});
            this.updNumberOfRacks.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.updNumberOfRacks.Name = "updNumberOfRacks";
            this.updNumberOfRacks.Size = new System.Drawing.Size(72, 20);
            this.updNumberOfRacks.TabIndex = 3;
            this.updNumberOfRacks.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.toolTip1.SetToolTip(this.updNumberOfRacks, "Select the number of racks to be quality controlled daily.");
            this.updNumberOfRacks.Value = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.updNumberOfRacks.TextChanged += new System.EventHandler(this.updNumberOfRacks_ValueChanged);
            this.updNumberOfRacks.ValueChanged += new System.EventHandler(this.updNumberOfRacks_ValueChanged);
            this.updNumberOfRacks.Leave += new System.EventHandler(this.updNumberOfRacks_Leave);
            // 
            // cmbPrimaryEnhancement
            // 
            this.cmbPrimaryEnhancement.AccessibleDescription = "Primary Enhancement Medium";
            this.cmbPrimaryEnhancement.AccessibleName = "Primary Enhancement Medium";
            this.cmbPrimaryEnhancement.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPrimaryEnhancement.Interval = 100;
            this.cmbPrimaryEnhancement.Items.AddRange(new object[] {
            "",
            "Low Ion Saline Solution (L.I.S.S.)",
            "Low Ion Saline Suspension (L.I.S.S.(",
            "PEG",
            "Protein Additive (albumin)"});
            this.cmbPrimaryEnhancement.Location = new System.Drawing.Point(180, 280);
            this.cmbPrimaryEnhancement.MaxLength = 50;
            this.cmbPrimaryEnhancement.Name = "cmbPrimaryEnhancement";
            this.cmbPrimaryEnhancement.Size = new System.Drawing.Size(378, 22);
            this.cmbPrimaryEnhancement.TabIndex = 10;
            this.toolTip1.SetToolTip(this.cmbPrimaryEnhancement, "Select the primary enhancement media.");
            this.cmbPrimaryEnhancement.SelectedIndexChanged += new System.EventHandler(this.cmbPrimaryEnhancement_SelectedIndexChanged);
            this.cmbPrimaryEnhancement.Leave += new System.EventHandler(this.cmbPrimaryEnhancement_Leave);
            // 
            // cmbSecondaryEnhancement
            // 
            this.cmbSecondaryEnhancement.AccessibleDescription = "Secondary Enhancement Medium";
            this.cmbSecondaryEnhancement.AccessibleName = "Secondary Enhancement Medium";
            this.cmbSecondaryEnhancement.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbSecondaryEnhancement.Interval = 100;
            this.cmbSecondaryEnhancement.Items.AddRange(new object[] {
            "",
            "Low Ion Saline Solution (L.I.S.S.)",
            "Low Ion Saline Suspension (L.I.S.S.(",
            "PEG",
            "Protein Additive (albumin)"});
            this.cmbSecondaryEnhancement.Location = new System.Drawing.Point(180, 304);
            this.cmbSecondaryEnhancement.MaxLength = 50;
            this.cmbSecondaryEnhancement.Name = "cmbSecondaryEnhancement";
            this.cmbSecondaryEnhancement.Size = new System.Drawing.Size(378, 22);
            this.cmbSecondaryEnhancement.TabIndex = 11;
            this.toolTip1.SetToolTip(this.cmbSecondaryEnhancement, "Optionally select the secondary enhancement media.");
            this.cmbSecondaryEnhancement.SelectedIndexChanged += new System.EventHandler(this.cmbSecondaryEnhancement_SelectedIndexChanged);
            this.cmbSecondaryEnhancement.Leave += new System.EventHandler(this.cmbSecondaryEnhancement_Leave);
            // 
            // lvCommercial
            // 
            this.lvCommercial.AccessibleDescription = "Reagent Q C Highlighted rows must be used and therefore cannot be unchecked.";
            this.lvCommercial.AccessibleName = "Reagent Q C Highlighted rows must be used and therefore cannot be unchecked.";
            this.lvCommercial.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvCommercial.CheckBoxes = true;
            this.lvCommercial.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colUsed,
            this.colReagentType,
            this.colTestWith,
            this.colMinReaction});
            this.lvCommercial.ContextMenu = this.contextMenu1;
            this.lvCommercial.FullRowSelect = true;
            this.lvCommercial.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lvCommercial.Location = new System.Drawing.Point(8, 12);
            this.lvCommercial.MultiSelect = false;
            this.lvCommercial.Name = "lvCommercial";
            this.lvCommercial.Size = new System.Drawing.Size(550, 236);
            this.lvCommercial.TabIndex = 8;
            this.toolTip1.SetToolTip(this.lvCommercial, "Check entries to be used for Daily Quality Control testing of reagent racks at th" +
        "is division.");
            this.lvCommercial.UseCompatibleStateImageBehavior = false;
            this.lvCommercial.View = System.Windows.Forms.View.Details;
            this.lvCommercial.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvCommercial_ItemCheck);
            this.lvCommercial.SelectedIndexChanged += new System.EventHandler(this.lvCommercial_SelectedIndexChanged);
            // 
            // colUsed
            // 
            this.colUsed.Text = "Used*";
            this.colUsed.Width = 45;
            // 
            // colReagentType
            // 
            this.colReagentType.Text = "Reagent Type";
            this.colReagentType.Width = 100;
            // 
            // colTestWith
            // 
            this.colTestWith.Text = "Test with Commerical QC Kit Reagent Types";
            this.colTestWith.Width = 225;
            // 
            // colMinReaction
            // 
            this.colMinReaction.Text = "Min. Reaction";
            this.colMinReaction.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.colMinReaction.Width = 85;
            // 
            // contextMenu1
            // 
            this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuEditReactionLevel});
            // 
            // mnuEditReactionLevel
            // 
            this.mnuEditReactionLevel.Index = 0;
            this.mnuEditReactionLevel.Text = "Edit Minimum Reaction Level";
            this.mnuEditReactionLevel.Click += new System.EventHandler(this.mnuEditReactionLevel_Click);
            // 
            // lvNonCommercial
            // 
            this.lvNonCommercial.AccessibleDescription = "Reagent Q C Highlighted rows must be used and therefore cannot be unchecked.";
            this.lvNonCommercial.AccessibleName = "Reagent Q C Highlighted rows must be used and therefore cannot be unchecked.";
            this.lvNonCommercial.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvNonCommercial.CheckBoxes = true;
            this.lvNonCommercial.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3,
            this.colMinReactions});
            this.lvNonCommercial.ContextMenu = this.contextMenu1;
            this.lvNonCommercial.FullRowSelect = true;
            this.lvNonCommercial.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lvNonCommercial.Location = new System.Drawing.Point(7, 12);
            this.lvNonCommercial.MultiSelect = false;
            this.lvNonCommercial.Name = "lvNonCommercial";
            this.lvNonCommercial.Size = new System.Drawing.Size(550, 236);
            this.lvNonCommercial.TabIndex = 7;
            this.toolTip1.SetToolTip(this.lvNonCommercial, "Check entries to be used for Daily Quality Control testing of reagent racks at th" +
        "is division.");
            this.lvNonCommercial.UseCompatibleStateImageBehavior = false;
            this.lvNonCommercial.View = System.Windows.Forms.View.Details;
            this.lvNonCommercial.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvNonCommercial_ItemCheck);
            this.lvNonCommercial.SelectedIndexChanged += new System.EventHandler(this.lvNonCommercial_SelectedIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Used*";
            this.columnHeader1.Width = 45;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Reagent Type";
            this.columnHeader2.Width = 100;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Test With";
            this.columnHeader3.Width = 200;
            // 
            // colMinReactions
            // 
            this.colMinReactions.Text = "Min. Reaction";
            this.colMinReactions.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.colMinReactions.Width = 90;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.CausesValidation = false;
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(552, 450);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 0;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click_1);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 412);
            this.grpImage.TabIndex = 5;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 44);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // grpActivate
            // 
            this.grpActivate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpActivate.Controls.Add(this.pnlTemplateType);
            this.grpActivate.Controls.Add(this.label3);
            this.grpActivate.Controls.Add(this.rdo1To25);
            this.grpActivate.Controls.Add(this.rdoAtoZ);
            this.grpActivate.Controls.Add(this.dtpAlertTime);
            this.grpActivate.Controls.Add(this.lblAlertTime);
            this.grpActivate.Controls.Add(this.updNumberOfRacks);
            this.grpActivate.Controls.Add(this.lblNumberOfRacks);
            this.grpActivate.Controls.Add(this.label2);
            this.grpActivate.Location = new System.Drawing.Point(64, 32);
            this.grpActivate.Name = "grpActivate";
            this.grpActivate.Size = new System.Drawing.Size(564, 80);
            this.grpActivate.TabIndex = 0;
            this.grpActivate.TabStop = false;
            // 
            // pnlTemplateType
            // 
            this.pnlTemplateType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlTemplateType.Controls.Add(this.rdoNonCommercial);
            this.pnlTemplateType.Controls.Add(this.rdoCommerical);
            this.pnlTemplateType.Location = new System.Drawing.Point(178, 8);
            this.pnlTemplateType.Name = "pnlTemplateType";
            this.pnlTemplateType.Size = new System.Drawing.Size(370, 24);
            this.pnlTemplateType.TabIndex = 1;
            // 
            // rdoNonCommercial
            // 
            this.rdoNonCommercial.AccessibleDescription = "Non Commercial";
            this.rdoNonCommercial.AccessibleName = "Non Commercial";
            this.rdoNonCommercial.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rdoNonCommercial.Location = new System.Drawing.Point(100, 0);
            this.rdoNonCommercial.Name = "rdoNonCommercial";
            this.rdoNonCommercial.Size = new System.Drawing.Size(116, 20);
            this.rdoNonCommercial.TabIndex = 2;
            this.rdoNonCommercial.Text = "&Non-Commercial";
            this.rdoNonCommercial.CheckedChanged += new System.EventHandler(this.CommercialOrNonCommercial);
            // 
            // rdoCommerical
            // 
            this.rdoCommerical.AccessibleDescription = "Commercial";
            this.rdoCommerical.AccessibleName = "Commercial";
            this.rdoCommerical.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rdoCommerical.Location = new System.Drawing.Point(2, 0);
            this.rdoCommerical.Name = "rdoCommerical";
            this.rdoCommerical.Size = new System.Drawing.Size(90, 20);
            this.rdoCommerical.TabIndex = 1;
            this.rdoCommerical.Text = "Co&mmercial";
            this.rdoCommerical.CheckedChanged += new System.EventHandler(this.CommercialOrNonCommercial);
            // 
            // label3
            // 
            this.label3.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label3.Location = new System.Drawing.Point(8, 8);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(168, 20);
            this.label3.TabIndex = 0;
            this.label3.Text = "Quality Check Template Type*";
            this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // rdo1To25
            // 
            this.rdo1To25.AccessibleDescription = "Rack Name 1 to 25";
            this.rdo1To25.AccessibleName = "Rack Name 1 to 25";
            this.rdo1To25.Location = new System.Drawing.Point(280, 56);
            this.rdo1To25.Name = "rdo1To25";
            this.rdo1To25.Size = new System.Drawing.Size(62, 20);
            this.rdo1To25.TabIndex = 6;
            this.rdo1To25.TabStop = true;
            this.rdo1To25.Text = "&1-26";
            this.rdo1To25.CheckedChanged += new System.EventHandler(this.rdo1To25_CheckedChanged);
            // 
            // rdoAtoZ
            // 
            this.rdoAtoZ.AccessibleDescription = "Rack Names A to Z";
            this.rdoAtoZ.AccessibleName = "Rack Names A to Z";
            this.rdoAtoZ.Location = new System.Drawing.Point(180, 56);
            this.rdoAtoZ.Name = "rdoAtoZ";
            this.rdoAtoZ.Size = new System.Drawing.Size(56, 20);
            this.rdoAtoZ.TabIndex = 5;
            this.rdoAtoZ.TabStop = true;
            this.rdoAtoZ.Text = "&A-Z";
            this.rdoAtoZ.CheckedChanged += new System.EventHandler(this.rdoAtoZ_CheckedChanged);
            // 
            // lblAlertTime
            // 
            this.lblAlertTime.Location = new System.Drawing.Point(280, 32);
            this.lblAlertTime.Name = "lblAlertTime";
            this.lblAlertTime.Size = new System.Drawing.Size(92, 20);
            this.lblAlertTime.TabIndex = 4;
            this.lblAlertTime.Text = "Daily Alert Time*";
            this.lblAlertTime.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblNumberOfRacks
            // 
            this.lblNumberOfRacks.Location = new System.Drawing.Point(8, 32);
            this.lblNumberOfRacks.Name = "lblNumberOfRacks";
            this.lblNumberOfRacks.Size = new System.Drawing.Size(176, 20);
            this.lblNumberOfRacks.TabIndex = 2;
            this.lblNumberOfRacks.Text = "Number of racks to be QC\'d daily*";
            this.lblNumberOfRacks.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(8, 56);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(168, 20);
            this.label2.TabIndex = 6;
            this.label2.Text = "Rack Names*";
            this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // groupBox1
            // 
            this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox1.Controls.Add(this.btnEditMinReaction);
            this.groupBox1.Controls.Add(this.lblInfo);
            this.groupBox1.Controls.Add(this.cmbSecondaryEnhancement);
            this.groupBox1.Controls.Add(this.lblSecondaryEnhancement);
            this.groupBox1.Controls.Add(this.lblPrimaryEnhancement);
            this.groupBox1.Controls.Add(this.cmbPrimaryEnhancement);
            this.groupBox1.Controls.Add(this.lvNonCommercial);
            this.groupBox1.Controls.Add(this.lvCommercial);
            this.groupBox1.Location = new System.Drawing.Point(64, 112);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(564, 332);
            this.groupBox1.TabIndex = 1;
            this.groupBox1.TabStop = false;
            // 
            // btnEditMinReaction
            // 
            this.btnEditMinReaction.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnEditMinReaction.EnabledButton = false;
            this.btnEditMinReaction.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnEditMinReaction.Image = null;
            this.btnEditMinReaction.Location = new System.Drawing.Point(420, 252);
            this.btnEditMinReaction.Name = "btnEditMinReaction";
            this.btnEditMinReaction.Size = new System.Drawing.Size(136, 23);
            this.btnEditMinReaction.TabIndex = 9;
            this.btnEditMinReaction.Click += new System.EventHandler(this.mnuEditReactionLevel_Click);
            this.btnEditMinReaction.MouseHover += new System.EventHandler(this.btnEditMinReaction_MouseHover);
            // 
            // lblInfo
            // 
            this.lblInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.lblInfo.Location = new System.Drawing.Point(4, 248);
            this.lblInfo.Name = "lblInfo";
            this.lblInfo.Size = new System.Drawing.Size(216, 28);
            this.lblInfo.TabIndex = 1;
            this.lblInfo.Text = "(Highlighted rows must be used and, therefore, cannot be unchecked.)";
            // 
            // lblSecondaryEnhancement
            // 
            this.lblSecondaryEnhancement.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.lblSecondaryEnhancement.Location = new System.Drawing.Point(8, 304);
            this.lblSecondaryEnhancement.Name = "lblSecondaryEnhancement";
            this.lblSecondaryEnhancement.Size = new System.Drawing.Size(176, 20);
            this.lblSecondaryEnhancement.TabIndex = 4;
            this.lblSecondaryEnhancement.Text = "Secondary Enhancement Medium";
            this.lblSecondaryEnhancement.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblPrimaryEnhancement
            // 
            this.lblPrimaryEnhancement.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.lblPrimaryEnhancement.Location = new System.Drawing.Point(8, 280);
            this.lblPrimaryEnhancement.Name = "lblPrimaryEnhancement";
            this.lblPrimaryEnhancement.Size = new System.Drawing.Size(172, 20);
            this.lblPrimaryEnhancement.TabIndex = 2;
            this.lblPrimaryEnhancement.Text = "Primary Enhancement Medium*";
            this.lblPrimaryEnhancement.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // errorProvider1
            // 
            this.errorProvider1.ContainerControl = this;
            this.errorProvider1.DataMember = "";
            this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
            // 
            // FrmConfigureReagent
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(632, 475);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.grpActivate);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnOK);
            this.hlphelpChm.SetHelpKeyword(this, "Configure_Daily_QC.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(560, 502);
            this.Name = "FrmConfigureReagent";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Configure Daily Reagent Rack Quality Control";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmConfigureReagent_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.FrmConfigureReagent_Load);
            this.VisibleChanged += new System.EventHandler(this.FrmConfigureReagent_VisibleChanged);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpActivate, 0);
            this.Controls.SetChildIndex(this.groupBox1, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.updNumberOfRacks)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpActivate.ResumeLayout(false);
            this.pnlTemplateType.ResumeLayout(false);
            this.groupBox1.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.errorProvider1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods

		private bool HasAuthority()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.EditConsultativeReports );
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmConfigureReagent_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			
			if(this.btnEditMinReaction.EnabledButton && !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnEditMinReaction.GetToolTip();
				textToSpeak = String.Concat(textToSpeak, this.btnOK.GetToolTip());
			}
			else if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			
			//
			this.SpeakMessage( textToSpeak );
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Configure Daily Reagent QC";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC051.FrmConfigureReagent());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.btnEditMinReaction.Text = "&Edit Minimum Reaction";
			this.btnEditMinReaction.EnabledButton = false;
			//
			this.cmbPrimaryEnhancement.Interval = 100;
			this.cmbSecondaryEnhancement.Interval = 100;
			//
			//set custom date and time format
			this.dtpAlertTime.CustomFormat = Common.VBECSDateTime.TimeFormat;

			//set current date value based on the division time zone
			this.dtpAlertTime.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		/// <summary>
		/// Enables or disables the controls depending
		/// on if they are changing the template type 
		/// </summary>
		/// <param name="bEnable"></param>
		private void EnableDisable(bool bEnable)
		{	
			this.updNumberOfRacks.Enabled = bEnable;
			this.dtpAlertTime.Enabled = bEnable;
			this.rdoAtoZ.Enabled = bEnable;
			this.rdo1To25.Enabled = bEnable;
			this.lvCommercial.Enabled = bEnable;
			this.lvNonCommercial.Enabled = bEnable;
			this.cmbPrimaryEnhancement.Enabled = bEnable;
			this.cmbSecondaryEnhancement.Enabled= bEnable;
		}
		/// <summary>
		/// Retrieves text for overwriting and existing template from the database
		/// </summary>
		/// <returns></returns>
		private string GetMessageText()
		{		
			string _informationString = "";
			try
			{
				//Get 'A <insert current template type> template exists defining the alternate inactivates the current template. Do you wish to proceed?
				_informationString = Common.StrRes.ConfMsg.UC051.OverwriteQCTemplate().ResString;
				string _existingTemplateType = "";
				if(this._existingDailyControl != null)
				{
					if(this._existingDailyControl.CommercialTemplateIndicator)
					{
						_existingTemplateType = "commercial";
					}
					else
					{
						_existingTemplateType = "non-commercial";
					}
				}
				_informationString = _informationString.Replace("<insert current template type>", _existingTemplateType);
			}
			catch (Exception e)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(e.Message));
			}

			//Return whole message
			return _informationString;
		}
		/// <summary>
		/// Called when the actor selects the template type of commercial or non-commercial
		/// this drives the whole screen by determining if they are changing the template type 
		/// If they change the type they enter a whole new template otherwise they edit the existing
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CommercialOrNonCommercial(object sender, System.EventArgs e)
		{
			string stest = string.Empty;
			if(this.rdoCommerical.Checked == true && sender.Equals(this.rdoNonCommercial))
			{
				return;
			}
			if(this.rdoNonCommercial.Checked == true && sender.Equals(this.rdoCommerical))
			{
				return;
			}

			//Added for CR564
			//We should check that they really want to make the change before its too late...
			if (!this._isLoading)
			{
				if ((this._existingDailyControl!=null)&&(this._existingDailyControl.CommercialTemplateIndicator != this.rdoCommerical.Checked))
				{
					//BR_51.22
					string retropectiveEntry = Common.StrRes.InfoMsg.UC051.BR5122().ResString;
					string _overwriteTemplateText = retropectiveEntry + " " + GetMessageText();
					DialogResult _overwriteResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(_overwriteTemplateText));
					if (_overwriteResult != DialogResult.Yes)
					{
						//we have to put the radio buttons back how they were, without calling all the events...
						_ignoreCheckChanged = true;
						if(this.rdoCommerical.Checked)
						{
							this.rdoNonCommercial.Checked = true;
						}
						else
						{
							this.rdoCommerical.Checked = true;
						}
						_ignoreCheckChanged = false;
						return;
					}
				}
			}
			//
			if (_ignoreCheckChanged)
			{
				return;
			}

            if (this._existingDailyControl != null)
            {
                this.LockController.RecordGuids.Add(this._existingDailyControl.DailyControlGuid);
                System.Data.DataTable dtRacks = BOL.Rack.GetConfigurableRackQC(this._existingDailyControl.DailyControlGuid);

                foreach (System.Data.DataRow dr in dtRacks.Rows)
                {
                    this.LockController.RecordGuids.Add((System.Guid)dr[RACK.RackGuid]);
                }
            }
			if(!this.SetLocks())
				return;

			this._dailyControl.SetInitialBrokenRules( this.Name, "DailyControl" );
			this._dailyControl.PrimaryEnhancementMedia.SetInitialBrokenRules( this.Name, "EnhancementMedia" );
			try
			{
				this._dailyControl.NumberOfRacks = (int) this.updNumberOfRacks.Value;
			}
			catch(FormatException)
			{
				this._dailyControl.NumberOfRacks = (int)this.updNumberOfRacks.Minimum;
			}
			this.lvCommercial.Visible = (this.rdoCommerical.Checked);
			this.lvNonCommercial.Visible = (this.rdoNonCommercial.Checked);
			this._dailyControl.CommercialTemplateIndicator = this.rdoCommerical.Checked;
			this._dailyControl.Comments = string.Empty;			//Otherwise, when switching between templates, comments will replicate
			
			//If there is an existing daily control
			if(this._existingDailyControl != null)
			{
				//If it is the same template type that they already have defined then they can carry on as usual
				if(this._existingDailyControl.CommercialTemplateIndicator == this._dailyControl.CommercialTemplateIndicator)
				{
					//Enable all controls
					this.EnableDisable(true);
					if(this._existingDailyControl.DailyControlGuid.Equals(System.Guid.Empty))
					{
						this._bFirstTimeConfiguration = true;
						this._dailyControl.DailyControlGuid = System.Guid.NewGuid();
					}
					else
					{
						this._dailyControl = new BOL.DailyControl(this._existingDailyControl.DailyControlGuid);
						//Fix for CR 559 - New DailyControl object will reset contained object broken rules.
						this._dailyControl.SetInitialBrokenRules( this.Name, "DailyControl" );
						this._dailyControl.PrimaryEnhancementMedia.SetInitialBrokenRules( this.Name, "EnhancementMedia" );

						this._bFirstTimeConfiguration = false;
						this._dailyControl.RecordStatusCode = Common.RecordStatusCode.Active;
						this.ReattachEvents();
					}
				}
					//They are changing the template type indicator
				else if (this._existingDailyControl.CommercialTemplateIndicator != this._dailyControl.CommercialTemplateIndicator)
				{
					//Removed for CR564
					
						this.EnableDisable(true);
						this._bFirstTimeConfiguration = true;
						this._dailyControl.DailyControlGuid = System.Guid.NewGuid();
				}
			}
				//No daily controls have been defined for this division so create a new daily control
			else if (this._existingDailyControl == null)
			{
				this.EnableDisable(true);
				this._bFirstTimeConfiguration = true;
				this._dailyControl.DailyControlGuid = System.Guid.NewGuid();
				
				this._dailyControl.SetInitialBrokenRules( this.Name, "DailyControl" );
				this._dailyControl.PrimaryEnhancementMedia.SetInitialBrokenRules( this.Name, "EnhancementMedia" );

				this._dailyControl.CommercialTemplateIndicator = this.rdoCommerical.Checked;
			}
            if (this._alReagentQCCommercialData == null)
			    this._alReagentQCCommercialData = BOL.ReagentType.GetReagentQCData(true, Common.LogonUser.LogonUserDivisionCode);
            if(this._alReagentQCNonCommercialData == null)
			    this._alReagentQCNonCommercialData = BOL.ReagentType.GetReagentQCData(false, Common.LogonUser.LogonUserDivisionCode);
            
			LoadReagentListView();
			SetUpForm();

			this.IsDirty=false;
		}

		private void SetUpForm()
		{	
			//this.StoreBrokenRules();
			BOL.Rack rack = new Rack();
			
			//this.RestoreBrokenRules();
			PopulateCombos();
			if(this._bFirstTimeConfiguration == false)
			{
			    this._isLoading = true;
				PopulateForm();
			    this._isLoading = false;
			}
			else
			{

				this.cmbPrimaryEnhancement.SelectedIndex = -1;
				this.cmbPrimaryEnhancement.Text = string.Empty;
				this.cmbSecondaryEnhancement.SelectedIndex = -1;
				this.cmbSecondaryEnhancement.Text = string.Empty;
				this.rdoAtoZ.Checked = false;
				this.rdo1To25.Checked = false;
				this.dtpAlertTime.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				this.updNumberOfRacks.Value = 1;
				this._dailyControl.SetInitialBrokenRules( this.Name, "DailyControl" );
				this._dailyControl.PrimaryEnhancementMedia.SetInitialBrokenRules( this.Name, "EnhancementMedia" );
			}
		}
		private void PopulateCombos()
		{
			this.cmbPrimaryEnhancement.Items.Clear();
			this.cmbPrimaryEnhancement.Items.Add("");
			this.cmbSecondaryEnhancement.Items.Clear();
			this.cmbSecondaryEnhancement.Items.Add("");
			_alEnhancementMedia = this._dailyControl.PrimaryEnhancementMedia.GetEnhancementMediaList();
			foreach(string strEnhancementMedia in _alEnhancementMedia)
			{
				int nCommaIndex = strEnhancementMedia.IndexOf(",");
				string enhancementMediaName = strEnhancementMedia.Substring(nCommaIndex + 1);
				this.cmbPrimaryEnhancement.Items.Add(enhancementMediaName);
				this.cmbSecondaryEnhancement.Items.Add(enhancementMediaName);
			}
		}

		#endregion

		private void cmbPrimaryEnhancement_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(this.cmbPrimaryEnhancement.SelectedIndex > 0)
			{
				this._dailyControl.PrimaryEnhancementMedia.EnhancementMediaName = cmbPrimaryEnhancement.Text;
				string selectedEnhancementMedia = this._alEnhancementMedia[cmbPrimaryEnhancement.SelectedIndex - 1].ToString();
				int nComma = selectedEnhancementMedia.IndexOf(",");
				//Subtracting one since we added a blank row to the combo box the index should be one greater
				//than the array list.
				this._dailyControl.PrimaryEnhancementMedia.EnhancementMediaId = System.Convert.ToInt32(selectedEnhancementMedia.Substring(0, nComma));
                this.IsDirty = true;
                this.OnValid(sender, e);
			}
			else
			{
				this._dailyControl.PrimaryEnhancementMedia.EnhancementMediaId = int.MinValue;
			}
			this.SetDirtyFlag(sender, e);
		}

		private void cmbSecondaryEnhancement_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(this.cmbSecondaryEnhancement.SelectedIndex > 0)
			{
				this._dailyControl.SecondaryEnhancementMedia.EnhancementMediaName = cmbSecondaryEnhancement.Text;
				string selectedEnhancementMedia = this._alEnhancementMedia[cmbSecondaryEnhancement.SelectedIndex - 1].ToString();
				int nComma = selectedEnhancementMedia.IndexOf(",");
				this._dailyControl.SecondaryEnhancementMedia.EnhancementMediaId = System.Convert.ToInt32(selectedEnhancementMedia.Substring(0, nComma));
			    this.IsDirty = true;
                this.OnValid(sender, e);
			}
			else
			{
				this._dailyControl.SecondaryEnhancementMedia.EnhancementMediaId = -1;
			}
			this.SetDirtyFlag(sender, e);
		}

		private void updNumberOfRacks_ValueChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				try
				{
					if (this._dailyControl != null)
					{
						try
						{
							this._dailyControl.NumberOfRacks = (int) updNumberOfRacks.Value;
							this.SetDirtyFlag(sender, e);
							this.errError.SetVbecsError(updNumberOfRacks, string.Empty); // **** 508 Compliance ***
						}
						catch(FormatException)
						{
							this._dailyControl.NumberOfRacks = 0;
						}

					}
				}
				catch(BusinessObjectException err)
				{
					this.errError.SetVbecsError(updNumberOfRacks, err.Message); // **** 508 Compliance ***
				}
			}
		}

		private void updNumberOfRacks_Leave(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				try
				{
					try
					{
						this._dailyControl.NumberOfRacks = (int) updNumberOfRacks.Value;
						this.SetDirtyFlag(sender, e);
						this.errError.SetVbecsError(updNumberOfRacks, string.Empty); // **** 508 Compliance ***
					}
					catch(FormatException err)
					{
						this.errError.SetVbecsError(updNumberOfRacks, err.Message); // **** 508 Compliance ***
						this._dailyControl.NumberOfRacks = 0;
					}
				}
				catch(BusinessObjectException err)
				{
					this.errError.SetVbecsError(updNumberOfRacks, err.Message); // **** 508 Compliance ***
				}
			}
		}

		private void dtpAlertTime_ValueChanged(object sender, System.EventArgs e)
		{
			
			if(!this._isLoading)
			{
				this._dailyControl.DailyAlertTime = dtpAlertTime.Value;
				SetDirtyFlag(sender, e);
                this.OnValid(sender, e);
			}
		}

		private void LoadReagentListView()
		{
			if(rdoCommerical.Checked)
			{
				this.lvCommercial.Items.Clear();
                //this._alReagentQCCommercialData = BOL.ReagentType.GetReagentQCData(this.rdoCommerical.Checked, Common.LogonUser.LogonUserDivisionCode);
                foreach(System.Object obj in this._alReagentQCCommercialData)
				{
					AddRowToCommercialListView(obj);
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvCommercial);
			}
			else
			{
				this.lvNonCommercial.Items.Clear();
                //this._alReagentQCNonCommercialData = BOL.ReagentType.GetReagentQCData(this.rdoCommerical.Checked, Common.LogonUser.LogonUserDivisionCode);
				foreach(System.Object obj in this._alReagentQCNonCommercialData)
				{
					AddRowToNonCommercialListView(obj);
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvNonCommercial);
			}
			//
			this.btnEditMinReaction.EnabledButton = false;
			this.mnuEditReactionLevel.Enabled = false;
		}

		
		private ListViewItem AddRowToListView(System.Object obj)
		{
		   //Daily use indicator
		    bool DUI = false;
		    //Must use indicator
		    bool MUI = false;
            ListViewItem lvi = new ListViewItem();
		    if (this.rdoCommerical.Checked == true)
		    {
                _reagentComType = (BOL.ReagentType)obj;
                lvi.Tag = _reagentComType;
		        //Store the Daily Use indicator
		        if (this._selectedReagentTypeCom != null)
		        {
                    if (_reagentComType.SortColumn == this._selectedReagentTypeCom.SortColumn)
		            {
		                DUI = this._selectedReagentTypeCom.DailyUseIndicator;
		            }
		            else
		            {
                        DUI = _reagentComType.DailyUseIndicator;
		            }
		        }
		        else
		        {
                    DUI = _reagentComType.DailyUseIndicator;
		        }
                //Store the Must Use Indicator
                MUI = _reagentComType.MustUseIndicator;
		    }
		    else
		    {
               
                _reagentNonComType = (BOL.ReagentType)obj;


                lvi.Tag = _reagentNonComType;
		        //Store the Daily Use indicator
		        if (this._selectedReagentTypeNonCom != null)
		        {
                    if (_reagentNonComType.SortColumn == this._selectedReagentTypeNonCom.SortColumn)
		            {
		                DUI = this._selectedReagentTypeNonCom.DailyUseIndicator;
		            }
		            else
		            {
                        DUI = _reagentNonComType.DailyUseIndicator;
		            }
		        }
		        else
		        {
                    DUI = _reagentNonComType.DailyUseIndicator;
		        }
                //Store the Must Use Indicator
                MUI = _reagentNonComType.MustUseIndicator;
		    }

		   

		    //If either the daily use indicator or the must use indicator are
		    //true then the list view item must be checked
		    if (DUI == true || MUI == true)
		    {
		        lvi.Checked = true;
		    }
		    //If the must use indicator is true then the list view item must
		    //have a background color of gray
		    if (MUI == true)
		    {
		        lvi.BackColor = System.Drawing.Color.FromKnownColor(KnownColor.Control);
		    }
		        //This is not  must use reagent so the back color is white
		    else
		    {
		        lvi.BackColor = System.Drawing.Color.FromKnownColor(KnownColor.Window);
		    }
		    if (this.rdoCommerical.Checked == true)
		    {
		        //Populate the list view with the appropriate data
                if (_reagentComType.SetVialId == String.Empty)
		        {
                    lvi.SubItems.Add(_reagentComType.ReagentTypeName);
		        }
		        else
		        {
                    lvi.SubItems.Add(_reagentComType.ReagentTypeName + " " + _reagentComType.SetVialId);
		        }
                lvi.SubItems.Add(_reagentComType.TestWithName);
		    }
		    else
		    {
                //Populate the list view with the appropriate data
                if (_reagentNonComType.SetVialId == String.Empty)
                {
                    lvi.SubItems.Add(_reagentNonComType.ReagentTypeName);
                }
                else
                {
                    lvi.SubItems.Add(_reagentNonComType.ReagentTypeName + " " + _reagentNonComType.SetVialId);
                }
                lvi.SubItems.Add(_reagentNonComType.TestWithName);
		    }
		    if (this.rdoCommerical.Checked == true)
		    {
		        //Store the Daily Use indicator
		        if (this._selectedReagentTypeCom != null)
		        {
                    if (_reagentComType.SortColumn == this._selectedReagentTypeCom.SortColumn)
		            {
		                lvi.SubItems.Add(this._selectedReagentTypeCom.ExpectedMinimumReactionTestResultText);
		            }
		            else
		            {
                        lvi.SubItems.Add(_reagentComType.ExpectedMinimumReactionTestResultText);
		            }
		        }
		        else
		        {
                    lvi.SubItems.Add(_reagentComType.ExpectedMinimumReactionTestResultText);
		        }
		    }
		    else
		    {
//Store the Daily Use indicator
		        if (this._selectedReagentTypeNonCom != null)
		        {
                    if (_reagentNonComType.SortColumn == this._selectedReagentTypeNonCom.SortColumn)
		            {
		                lvi.SubItems.Add(this._selectedReagentTypeNonCom.ExpectedMinimumReactionTestResultText);
		            }
		            else
		            {
                        lvi.SubItems.Add(_reagentNonComType.ExpectedMinimumReactionTestResultText);
		            }
		        }
		        else
		        {
                    lvi.SubItems.Add(_reagentNonComType.ExpectedMinimumReactionTestResultText);
		        }

		    }
		    
		    //Return the populated list view
			return lvi;

		}

		private void AddRowToCommercialListView(System.Object obj)
		{
			ListViewItem lvi = this.AddRowToListView(obj);
			this.lvCommercial.Items.Add(lvi);
		}

		private void AddRowToNonCommercialListView(System.Object obj)
		{
			ListViewItem lvi = this.AddRowToListView(obj);
			this.lvNonCommercial.Items.Add(lvi);
		}

	

		private void lvCommercial_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			int nIndex = Int32.MinValue;
			//Check to make sure that a valid tag exists
			if(lvCommercial.Items[e.Index].Tag != null)
			{
				
				this.IsDirty=true;
                _reagentComType = (BOL.ReagentType)lvCommercial.Items[e.Index].Tag;
								
				//Store the must use indicator
				int MUI = int.MinValue;
                if (_reagentComType.MustUseIndicator == false)
				{
                    MUI = System.Convert.ToInt32(_reagentComType.MustUseIndicator);
				}
				else
				{
					MUI = 1;
				}
				//If the must use indicator is true
				if(MUI == 1)
				{
					//Do not allow the user to uncheck the row
					e.NewValue = System.Windows.Forms.CheckState.Checked;
				}
					//The must use indicator does not apply so the daily
					//use indicator must apply
				else
				{
					if(e.NewValue == System.Windows.Forms.CheckState.Checked)
					{
                        _reagentComType.DailyUseIndicator = true;
					}
					else
					{
                        _reagentComType.DailyUseIndicator = false;
					}
				}
                if (_reagentComType.SetVialId == "4")
				{
					//Get the index of SC3
					nIndex = e.Index - 1;
					//If they click SC4 then we must also click SC3 if it is unchecked.
					if(e.NewValue == System.Windows.Forms.CheckState.Checked 
						&& lvCommercial.Items[nIndex].Checked == false)
					{
                        //CR 3326
                        _reagentComType.DailyUseIndicator = true;
                        lvCommercial.Items[nIndex].Checked = true;
					}
				}
                if (_reagentComType.SetVialId == "3")
				{
					//Get the index of SC4
					nIndex = e.Index + 1;
					//If they are unchecking SC3
					if(e.NewValue == System.Windows.Forms.CheckState.Unchecked)
					{
						//If SC4 is checked then cannot uncheck SC3
						if(lvCommercial.Items[nIndex].Checked)
						{
                            //CR 3326
                            _reagentComType.DailyUseIndicator = true;
                            //Do not allow the user to uncheck the row
							e.NewValue = System.Windows.Forms.CheckState.Checked;
						}
					}
				}
			}
            this.OnValid(sender, e);
		}

		private void rdoAtoZ_CheckedChanged(object sender, System.EventArgs e)
		{
			if(rdoAtoZ.Checked == true || this.rdo1To25.Checked == true)
			{
				this._dailyControl.RackNamesIndicator = rdoAtoZ.Checked;
				this.SetDirtyFlag(sender, e);
			}
		}

		private void rdo1To25_CheckedChanged(object sender, System.EventArgs e)
		{
			if(rdoAtoZ.Checked == true || this.rdo1To25.Checked == true)
			{
				this._dailyControl.RackNamesIndicator = rdoAtoZ.Checked;
				this.SetDirtyFlag(sender, e);
			}
		}

		private void lvCommercial_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(lvCommercial.SelectedIndices.Count > 0)
			{
                this._selectedReagentTypeCom = (BOL.ReagentType)lvCommercial.Items[lvCommercial.SelectedIndices[0]].Tag;
                this.mnuEditReactionLevel.Enabled = (this._selectedReagentTypeCom.ExpectedMinimumReaction != "0");
                this.btnEditMinReaction.EnabledButton = (this._selectedReagentTypeCom.ExpectedMinimumReaction != "0");
			}
			else
			{
				this.mnuEditReactionLevel.Enabled = false;
				this.btnEditMinReaction.EnabledButton = false;
			}
			this.SpeakListViewWithCheckBox(lvCommercial);
		}
	
		private void FrmConfigureReagent_Load(object sender, System.EventArgs e)
		{
			
			this.EnableDisable(false);
			//Get existing daily control
			
			this._existingDailyControl = this._dailyControl.GetExistingDailyControlTemplate();
			if(this._existingDailyControl != null)
			{
				this.rdoCommerical.Checked = (this._existingDailyControl.CommercialTemplateIndicator == true);
				this.rdoNonCommercial.Checked = (this._existingDailyControl.CommercialTemplateIndicator == false);
                CommercialOrNonCommercial(sender, e);     
			}
		}
		/// <summary>
		/// Disables the OK button if the object is not valid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnInvalid(object sender, System.EventArgs e)
		{			
			btnOK.EnabledButton = false;
			//Need to set this not just on mousehover for 508 compliance
			this.btnOK.SetToolTip(	
				Common.Utility.SumBrokenRulesMessages(	_dailyControl.GetBrokenRulesMessage(this.Name), 
				_dailyControl.PrimaryEnhancementMedia.GetBrokenRulesMessage(this.Name), 
				_dailyControl.SecondaryEnhancementMedia.GetBrokenRulesMessage(this.Name) ) );
		    if (this.rdoCommerical.Checked == true)
		    {
		        if (this._selectedReagentTypeCom != null)
		        {
		            if (_selectedReagentTypeCom.ExpectedMinimumReaction == "0")
		            {
		                this.btnEditMinReaction.SetToolTip(
		                    Common.StrRes.Tooltips.UC051.CannotChangeMinimumReaction().ResString);
		            }
		            else if (_selectedReagentTypeCom.ExpectedMinimumReaction != "0")
		            {
		                this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.EditMinimumReaction().ResString);
		            }
		            else
		            {
		                this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.SelectReagentType().ResString);
		            }
		        }
		    }
		    else
		    {
                if (this._selectedReagentTypeNonCom != null)
                {
                    if (_selectedReagentTypeNonCom.ExpectedMinimumReaction == "0")
                    {
                        this.btnEditMinReaction.SetToolTip(
                            Common.StrRes.Tooltips.UC051.CannotChangeMinimumReaction().ResString);
                    }
                    else if (_selectedReagentTypeNonCom.ExpectedMinimumReaction != "0")
                    {
                        this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.EditMinimumReaction().ResString);
                    }
                    else
                    {
                        this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.SelectReagentType().ResString);
                    }
                }
		    }
		}

		/// <summary>
		/// Enables the OK button if the object is valid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnValid(object sender, System.EventArgs e)
		{
			if( _dailyControl.IsValid && 
				_dailyControl.PrimaryEnhancementMedia.IsValid &&
				_dailyControl.SecondaryEnhancementMedia.IsValid )
			{
				if(this.IsDirty && !this._isLoading)
				{
				    btnOK.EnabledButton = true;
				    btnOK.SetToolTip("");
				}
				else
				{
				     btnOK.EnabledButton = false;
				     this.btnOK.SetToolTip("No changes have been made.");
				}
			}
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
            if(this.btnOK.EnabledButton == false && !this.IsDirty)
            {
                
                this.btnOK.SetToolTip("No changes have been made.");

            }
            else
            {
                this.btnOK.SetToolTip(
                Common.Utility.SumBrokenRulesMessages(_dailyControl.GetBrokenRulesMessage(this.Name),
                                                     _dailyControl.PrimaryEnhancementMedia.GetBrokenRulesMessage(this.Name),
                                                     _dailyControl.SecondaryEnhancementMedia.GetBrokenRulesMessage(this.Name)));
            }
			
		}

		private BOL.ReagentType GetReagentTypeFromDataRow(System.Data.DataRow dr)
		{
			BOL.ReagentType reagentType = new BOL.ReagentType();
			reagentType = new BOL.ReagentType(dr);
			this.ReattachEvents();
			return reagentType;
		}

        private void PopulateForm()
        {
            try
            {
                this.updNumberOfRacks.Value = this._dailyControl.NumberOfRacks;
                if (!this._bFirstTimeConfiguration)
                {
                    //Need to remove the broken rule
                    this._dailyControl.NumberOfRacks = this._dailyControl.NumberOfRacks;
                }
            }
            catch (FormatException)
            {
                this.updNumberOfRacks.Value = this.updNumberOfRacks.Minimum;
            }
            this.dtpAlertTime.Text = this._dailyControl.DailyAlertTime.TimeOfDay.ToString();
            if (!this._bFirstTimeConfiguration)
            {
                //Need to remove the broken rule
                this._dailyControl.DailyAlertTime = this._dailyControl.DailyAlertTime;
            }
            //this is write once
            if (this._dailyControl.RackNamesIndicator)
            {
                this.rdoAtoZ.Checked = true;

            }
            else
            {
                this.rdo1To25.Checked = true;

            }
            if (!this._bFirstTimeConfiguration)
            {
                this.rdoAtoZ.Enabled = false;
                this.rdo1To25.Enabled = false;
                if (this._dailyControl != null)
                {
                    if (rdoAtoZ.Checked == true || this.rdo1To25.Checked == true)
                    {
                        //Needed to remove the broken rule
                        this._dailyControl.RackNamesIndicator = rdoAtoZ.Checked;
                        this._dailyControl.IsDirty = false;
                        this.btnOK.EnabledButton = false;
                    }
                }
            }

            int nCtr = 1;
            foreach (object obj in this.cmbPrimaryEnhancement.Items)
            {
                if (obj != null)
                {
                    if (nCtr == this._dailyControl.PrimaryEnhancementMedia.EnhancementMediaId)
                    {
                        this.cmbPrimaryEnhancement.SelectedIndex = nCtr;
                        break;
                    }
                }
                nCtr++;
            }
            nCtr = 1;
            foreach (object obj in this.cmbSecondaryEnhancement.Items)
            {
                if (obj != null)
                {
                    if (nCtr == this._dailyControl.SecondaryEnhancementMedia.EnhancementMediaId)
                    {
                        this.cmbSecondaryEnhancement.SelectedIndex = nCtr;
                        break;
                    }
                }
                nCtr++;
            }
            
        }

	    private int SelectedIndexInReagentTypeArrayList(System.Collections.ArrayList al, int searchID, string stestWith, string svialID)
		{
			int nCtr = 0;
            
		    foreach (Object obj in al)
		    {
                if (((BOL.ReagentType)(obj)).ReagentTypeId == searchID && ((BOL.ReagentType)(obj)).TestWithName == stestWith && ((BOL.ReagentType)(obj)).SetVialId == svialID)
		        {
				    return nCtr;
				}
				nCtr ++;
			}
	        return -1;
		}


		private void btnOK_Click(object sender, System.EventArgs e)
		{
			//Check if this is an update to an existing record if it is
			//require the comment
			if(!this._bFirstTimeConfiguration && this.IsDirty)
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Confirm Changes", "A comment is required to confirm daily reagent QC template changes.", "PS");

				dlg.ShowDialogFromLockedParent(this,false);

				this._dailyControl.Comments = dlg.Comment;
				if(dlg.DialogResult == System.Windows.Forms.DialogResult.Cancel || this._dailyControl.Comments.Length == 0)
				{
					return;
				}
				else
				{
					try
					{
						if(!Save())
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Configure Daily Reagent QC"));
						}
					}
					catch(Exception ex)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
						return;
					}
				}
			}
			else
			{
				DialogResult _saveResult =GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("daily control"));
				if (_saveResult == DialogResult.Yes)
				{
					try
					{
						if(!Save())
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Configure Daily Reagent QC"));
						}
					}
					catch(Exception ex)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
						return;
					}
				}
				else
				{
					return;
				}
			}
			this.IsDirty=false;
			this.Close();
		}

		private bool Save()
		{
			this._dailyControl.PopulateRackData(this._dailyControl.DailyControlGuid);
			
			if(this._dailyControl.CommercialTemplateIndicator)
			{
				return this._dailyControl.SaveAllDailyControlData(this._alReagentQCCommercialData, this._dailyControl.CommercialTemplateIndicator, Common.UpdateFunction.UC051FrmConfigureReagent);
			}
			else
			{
				return this._dailyControl.SaveAllDailyControlData(this._alReagentQCNonCommercialData, this._dailyControl.CommercialTemplateIndicator, Common.UpdateFunction.UC051FrmConfigureReagent);
			}
		}

		private void btnCancel_Click_1(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void lvNonCommercial_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(lvNonCommercial.SelectedIndices.Count > 0)
			{
				this._selectedReagentTypeNonCom = (BOL.ReagentType) lvNonCommercial.Items[lvNonCommercial.SelectedIndices[0]].Tag;
                this.mnuEditReactionLevel.Enabled = (this._selectedReagentTypeNonCom.ExpectedMinimumReaction != "0");
                this.btnEditMinReaction.EnabledButton = (this._selectedReagentTypeNonCom.ExpectedMinimumReaction != "0");
			}
			else
			{
				this.mnuEditReactionLevel.Enabled = false;
				this.btnEditMinReaction.EnabledButton = false;
			}
			this.SpeakListViewWithCheckBox(lvNonCommercial);
		}

		private void lvNonCommercial_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			int nIndex = Int32.MinValue;
			//Check to make sure that a valid tag exists
			if(lvNonCommercial.Items[e.Index].Tag != null)
			{
			
				this.IsDirty=true;
				
				//Get the undelying row of the selected reagent
                _reagentNonComType = (BOL.ReagentType)lvNonCommercial.Items[e.Index].Tag;
				
				//Store the must use indicator
				int MUI = int.MinValue;
                if (_reagentNonComType.MustUseIndicator == false)
				{
                    MUI = System.Convert.ToInt32(_reagentNonComType.MustUseIndicator);
				}
				else
				{
					MUI = 1;
				}
				//If the must use indicator is true
				if(MUI == 1)
				{
					//Do not allow the user to uncheck the row
					e.NewValue = System.Windows.Forms.CheckState.Checked;
				}
				//The must use indicator does not apply so the daily
				//use indicator must apply
				else
				{
					if(e.NewValue == System.Windows.Forms.CheckState.Checked)
					{
                        _reagentNonComType.DailyUseIndicator = true;
					}
					else
					{
                        _reagentNonComType.DailyUseIndicator = false;
					}
				}
                if (_reagentNonComType.SetVialId == "4")
				{
					//Get the index of SC3
					nIndex = e.Index - 1;
					//If they click SC4 then we must also click SC3 if it is unchecked.
					if(e.NewValue == System.Windows.Forms.CheckState.Checked 
						&& lvNonCommercial.Items[nIndex].Checked == false)
					{
                        //CR 3326
                        _reagentNonComType.DailyUseIndicator = true;
                        lvNonCommercial.Items[nIndex].Checked = true;
					}
				}
                if (_reagentNonComType.SetVialId == "3")
				{
					//Get the index of SC4
					nIndex = e.Index + 1;
					//If they are unchecking SC3
					if(e.NewValue == System.Windows.Forms.CheckState.Unchecked)
					{
						//If SC4 is checked then cannot uncheck SC3
						if(lvNonCommercial.Items[nIndex].Checked)
						{
							//Do not allow the user to uncheck the row
                            //CR 3326
                            _reagentNonComType.DailyUseIndicator = true;
							e.NewValue = System.Windows.Forms.CheckState.Checked;
						}
					}
				}
			}
            this.OnValid(sender, e);
		}

		private void FrmConfigureReagent_VisibleChanged(object sender, System.EventArgs e)
		{
			if(this.Visible == true)
			{
				if(BOL.DailyControl.PartiallyCompletedQC() == true)
				{
					string message = string.Empty;
					//BR_51.21
					if(BOL.Rack.GetDailyQCRacks(BOL.VBECSDateTime.GetDivisionCurrentDateTime(Common.LogonUser.LogonUserDivisionCode)).Rows.Count > 0)
					{
						message = Common.StrRes.InfoMsg.UC051.BR5121().ResString;
					}
					//BR_55.02
					message = message + Common.StrRes.InfoMsg.UC055.CannotConfigureTesting(ThisUser.CurrentDivisionRole.Division.DivisionName).ResString;
					MessageBox.Show(this, message, "QC Information");				
					this.Close();
				}
			}
		}

		private void mnuEditReactionLevel_Click(object sender, System.EventArgs e)
		{
            //CR 3397 for build 2.0.0.4
		    if (this._dailyControl.CommercialTemplateIndicator)
		    {
                ProcessEditReaction(_selectedReagentTypeCom);
		    }
		    else
		    {
		        ProcessEditReaction(_selectedReagentTypeNonCom);
		    }
		}

	    private void ProcessEditReaction(BOL.ReagentType reagentType)
	    {
            if (reagentType != null)
            {
                if (reagentType.ExpectedMinimumReaction != "0")
                {
                    int nSelectedIndex = 0;
                    if (this._dailyControl.CommercialTemplateIndicator)
                    {
                        nSelectedIndex = this.SelectedIndexInReagentTypeArrayList(this._alReagentQCCommercialData,
                            reagentType.ReagentTypeId, reagentType.TestWithName, reagentType.SetVialId);
                    }
                    else
                    {
                        nSelectedIndex = this.SelectedIndexInReagentTypeArrayList(this._alReagentQCNonCommercialData,
                           reagentType.ReagentTypeId, reagentType.TestWithName, reagentType.SetVialId);
                    }
                    if (nSelectedIndex == -1)
                    {
                        throw new Exception("Can't find selected row in reagent type list.");
                    }

                    string expMinReactionText = reagentType.ExpectedMinimumReactionTestResultText;
                    DlgEditMinimumReaction _dlg = new DlgEditMinimumReaction(ref reagentType);

                    _dlg.ShowDialogFromLockedParent(this, false);
                    if (_dlg.DialogResult == DialogResult.OK)
                    {
                        if (this._dailyControl.CommercialTemplateIndicator)
                        {
                            ((BOL.ReagentType)this._alReagentQCCommercialData[nSelectedIndex]).ExpectedMinimumReactionTestResultText = reagentType.ExpectedMinimumReactionTestResultText;
                        }
                        else
                        {
                            ((BOL.ReagentType) this._alReagentQCNonCommercialData[nSelectedIndex]).ExpectedMinimumReactionTestResultText = reagentType.ExpectedMinimumReactionTestResultText;
                        }
                        LoadReagentListView();
                    }
                    else
                    {
                        reagentType.ExpectedMinimumReactionTestResultText = expMinReactionText;
                    }

                }
            }
	    }
		private void cmbSecondaryEnhancement_Leave(object sender, System.EventArgs e)
		{
			//Fix for CR 560
			if (this.cmbSecondaryEnhancement.SelectedIndex<0)
			{
				this.cmbSecondaryEnhancement.Text = "";
			}
		}

		private void cmbPrimaryEnhancement_Leave(object sender, System.EventArgs e)
		{
			if (this.cmbPrimaryEnhancement.SelectedIndex<0)
			{
				this.cmbPrimaryEnhancement.Text = "";
			}
		}

		private void btnEditMinReaction_MouseHover(object sender, System.EventArgs e)
		{
		    if (this.rdoCommerical.Checked == true)
		    {
                if ((this._selectedReagentTypeCom != null) && (_selectedReagentTypeCom.ExpectedMinimumReaction == "0"))
		        {
		            this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.CannotChangeMinimumReaction().ResString);
		        }
                else if ((this._selectedReagentTypeCom != null) && (_selectedReagentTypeCom.ExpectedMinimumReaction != "0"))
		        {
		            this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.EditMinimumReaction().ResString);
		        }
		        else
		        {
		            this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.SelectReagentType().ResString);
		        }
		    }
		    else
		    {
                if ((this._selectedReagentTypeNonCom != null) && (_selectedReagentTypeNonCom.ExpectedMinimumReaction == "0"))
                {
                    this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.CannotChangeMinimumReaction().ResString);
                }
                else if ((this._selectedReagentTypeNonCom != null) && (_selectedReagentTypeNonCom.ExpectedMinimumReaction != "0"))
                {
                    this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.EditMinimumReaction().ResString);
                }
                else
                {
                    this.btnEditMinReaction.SetToolTip(Common.StrRes.Tooltips.UC051.SelectReagentType().ResString);
                }
		    }
		}

		
		private void rdoNonCommercial_CheckedChanged(object sender, System.EventArgs e)
		{
			CommercialOrNonCommercial(sender, e);
			
		}

		private void rdoCommerical_CheckedChanged(object sender, System.EventArgs e)
		{
			CommercialOrNonCommercial(sender, e);
		}

		private void dtpAlertTime_Leave(object sender, System.EventArgs e)
		{
			this.rdoAtoZ.Focus();
		}

		
	}
}

